import random
import Const

"""AI用クラス
"""
class PlayerAI:
    
    def play(self,kiban,qtable,greedy):
        key = kiban.kibanToString() #棋盤情報から状態情報へ変換
        data = qtable.get(key)      #状態に対応するQ値を取得

        ret = kiban.serchBlank()    #打てる箇所を取得
        if random.random() < greedy:#一定確率でランダムに打つ(学習するため)
             return random.choice(ret) #ランダムに打てる箇所を選択        
        else:
            xymax=[]
            xymax.append([ret[0][0],ret[0][1]]) #打てる箇所の1件目を第一候補とする
            max = data[ret[0][0]][ret[0][1]]
            ret.pop(0)

            for xy in ret:  #打てる箇所の2件目から処理。Q値の高い箇所を探す
                if data[xy[0]][xy[1]] > max:    #最高Q値があった場合に格納する
                    max = data[xy[0]][xy[1]]
                    xymax.clear()
                    xymax.append([xy[0],xy[1]])
                elif data[xy[0]][xy[1]] == max: #最高Q値が複数ある場合に格納する
                    xymax.append(([xy[0],xy[1]]))                   

            return random.choice(xymax)   #最高Q値が複数あると想定し、その中からランダム選択

    def whois(self):
        return Const.AI
